/*

*/
import java.io.*;

public class Java7_TestInheritance
{
   public static void main(String[] args) throws IOException, InterruptedException
   {
      // Create a command line for each child.
      ProcessBuilder pb1 = new ProcessBuilder("java", "RemoveVowels");
      ProcessBuilder pb2 = new ProcessBuilder("java", "ToUpperCase");

      // Have the first child inherit the parent's standard input stream.
      pb1.redirectInput( ProcessBuilder.Redirect.INHERIT );

      // Have both children inherit the parent's standard error stream.
      pb1.redirectError( ProcessBuilder.Redirect.INHERIT );
      pb2.redirectError( ProcessBuilder.Redirect.INHERIT );

      // Have the second child inherit the parent's standard output streams.
      pb2.redirectOutput( ProcessBuilder.Redirect.INHERIT );

      // Execute the second child.
      Process process2 = pb2.start();

      // Set System.out to be the standard input of the second child.
      System.setOut( new PrintStream( process2.getOutputStream() ) );

      // Now have the first child inherit the parent's (new value of) stdout.
      pb1.redirectOutput( ProcessBuilder.Redirect.INHERIT );

      // Execute the first child (start the pipeline).
      Process process1 = pb1.start();

      // Wait for the second stage child to finish its work.
      process2.waitFor();  // this throws InterruptedException
   }
}